/*----------------------------------------------------------------------------*\
					==============================
					 y_hooks - Hook any callback!
					==============================
Description:
	Automatically hooks any callbacks with a very simple syntax.
Legal:
	Version: MPL 1.1
	
	The contents of this file are subject to the Mozilla Public License Version 
	1.1 (the "License"); you may not use this file except in compliance with 
	the License. You may obtain a copy of the License at 
	http://www.mozilla.org/MPL/
	
	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	The Original Code is the SA:MP callback hooks include.
	
	The Initial Developer of the Original Code is Alex "Y_Less" Cole.
	Portions created by the Initial Developer are Copyright (C) 2008
	the Initial Developer. All Rights Reserved.
	
	Contributors:
		ZeeX, koolk, JoeBullet/Google63, g_aSlice/Slice
	
	Thanks:
		JoeBullet/Google63 - Handy arbitrary ASM jump code using SCTRL.
		Peter, Cam - Support.
		ZeeX, g_aSlice/Slice, Popz, others - Very productive conversations.
		koolk - IsPlayerinAreaEx code.
		TheAlpha - Danish translation.
		breadfish - German translation.
		Fireburn - Dutch translation.
		yom - French translation.
		50p - Polish translation.
		Zamaroht - Spanish translation.
		Dracoblue, sintax, mabako, Xtreme, other coders - Producing other modes
			for me to strive to better.
		Pixels^ - Running XScripters where the idea was born.
		Matite - Pestering me to release it and using it.
	
	Very special thanks to:
		Thiadmer - PAWN, whose limits continue to amaze me!
		Kye/Kalcor - SA:MP.
		SA:MP Team past, present and future - SA:MP.
	
Version:
	2.0
Changelog:
	02/01/13:
		Rewrote the system to do away with ALS.
		Removed overflow checks in every callback.
		Streamlined code.
	14/04/12:
		Added crash fix from Slice, now returning correct values.
		Fixed ALS detection of mode callbacks.
	25/02/12:
		Extracted most of the code to a separate file.
	17/03/11:
		Second complete re-write using another new technique.  Now VERY fast!
		Updated OnPlayerUpdate code using Google63's SCTRL jump code.
	06/08/10:
		First version
\*----------------------------------------------------------------------------*/

#include "y_version"

#include <a_samp>

#include "..\y_debug"
#include "..\y_amx"

#include "y_plugins"

#define ALS_MAKE<%0...%1> %0S@@%1

#if !defined YSI_FILTERSCRIPT
	new
		bool:YSI_FILTERSCRIPT = false;
#endif

#define hook%0On%1(%2) UNIQUE_FUNCTION<@yH_%1...>(%2);UNIQUE_FUNCTION<@yH_%1...>(%2)
#define rehook%0On%1(%2) UNIQUE_FUNCTION<@yH_%1...>(%2)

#define Hook:%0On%1(%2) UNIQUE_FUNCTION<@yH_%1...%0>(%2);UNIQUE_FUNCTION<@yH_%1...%0>(%2)

#include "..\y_als"

#if !defined HOOKS_MAX_UPDATES
	// Slight increase from the previous version.
	#define HOOKS_MAX_UPDATES           (8)
#endif

// These defines now use the much more generic ALS code so that the list of
// callbacks is only done in one place.
#define HOOK_R_INT<%0,%2>(%3) return ALS_MAKE<..._On%0>(ALS_TS_%3);
#define HOOK_RETURN<%0> ALS_DO:HOOK_R_INT<%0>

#define HOOK_F_INT<%0,%2>(%3) forward ALS_MAKE<..._On%0>(ALS_KS_%3);
#define HOOK_FORWARD<%0> ALS_DO:HOOK_F_INT<%0>

#define HOOK_C_INT<%0,%2>(%3) ret=ALS_MAKE<..._On%0>(ALS_TS_%3);hooks_do_hooks_call_no_als:return ret;
#define HOOK_CALL<%0> ALS_DO:HOOK_C_INT<%0>

static stock
	YSI_g_sCallbackAddresses[HOOKS_MAX_UPDATES * _:ALS],
	YSI_g_sCallbackStart[ALS],
	YSI_g_sCallbackEnd[ALS];

static Hooks_Blank_Return1N()
{
	// Bug fix from Slice.
	return -1;
}

static Hooks_Blank_Return0()
{
	return 0;
}

static Hooks_Blank_Return1()
{
	return 1;
}

stock Hooks_RedirectPublic(from[], to[], final = 1)
{
	P:4("Hooks_RedirectPublic called: \"%s\", \"%s\"", from, to);
	new
		addr = strfind(from, "(");
	if (addr != -1) from[addr] = '\0';
	if (AMX_GetPublicEntry(0, addr, from))
	{
		new
			pointer,
			ret = AMX_Read(addr);
		if (AMX_GetPublicPointer(0, pointer, to))
		{
			AMX_Write(addr, pointer);
		}
		else
		{
			// Can't find the next element, just remove this callback entirely.
			// Note that in some cases the previous ALS include will have
			// already (due to the constant chaining order) determined that
			// there IS a next callback for this type (because there is) and set
			// some internal variable stating this fact.  When it comes to call
			// it, however, the callback will no longer exist (unless PAWN
			// buffers callbacks in an efficient structure, which is possible).
			// UPDATE: Clearly not.
			switch (final)
			{
				case 0:
				{
					#emit CONST.pri   Hooks_Blank_Return0
					#emit STOR.S.pri  pointer
				}
				case -1:
				{
					#emit CONST.pri   Hooks_Blank_Return1N
					#emit STOR.S.pri  pointer
				}
				default:
				{
					#emit CONST.pri   Hooks_Blank_Return1
					#emit STOR.S.pri  pointer
				}
			}
			AMX_Write(addr, pointer);
		}
		return ret;
	}
	return 0;
}

/*----------------------------------------------------------------------------*\
Function:
	Hooks_AddOne
Params:
	idx - Public function table index.
	&toaddidx - Current slot in the global array.
Return:
	-
Notes:
	Stores a public function by index in to the array of function pointers.
\*----------------------------------------------------------------------------*/

static Hooks_AddOne(idx, &toaddidx)
{
	// This is a combination between the count and the end point.
	if (toaddidx == sizeof (YSI_g_sCallbackAddresses))
	{
		P:E("Out of y_hooks callback addresses");
	}
	else
	{
		new
			addr = (idx - 1) * 8 + AMX_HEADER_PUBLICS;
		#emit LREF.S.pri addr
		#emit STOR.S.pri addr
		YSI_g_sCallbackAddresses[toaddidx++] = addr;
	}
}

/*----------------------------------------------------------------------------*\
Function:
	Hooks_FindAll
Params:
	name[] - Callback to find.
	&toaddidx - Current slot in the global array.
	&start - Where to store the start index.
	&end - Where to store the end index.
Return:
	-
Notes:
	Finds all public functions with the standard y_hooks prefix and a suffix of
	the given string, as well as the y_hooks ALS next call (if there is one).
\*----------------------------------------------------------------------------*/

static Hooks_FindAll(name[], &toaddidx, &start, &end)
{
	P:4("Hooks_FindAll called: %s %d", name, toaddidx);
	P:4("Hooks_FindAll called: %s %d", name, toaddidx);
	new
		buffer[32],
		len = strlen(name),
		idx;
	start = toaddidx - 1;
	// Find all the y_hooks "hook" callbacks.
	while ((idx = AMX_GetPublicNamePrefix(idx, buffer, _A<@yH_>)))
	{
		if (!strcmp(name, buffer[1], false, len) && ('0' <= buffer{4 + len} <= '9'))
		{
			P:6("%d (%d) %s", idx, toaddidx, unpack(buffer));
			Hooks_AddOne(idx, toaddidx);
		}
	}
	// Find the next item in the ALS call chain.
	buffer = "S@@_On";
	strcat(buffer, name);
	// Add 1 as the return of "funcidx" doesn't quite match the return of y_amx.
	if ((idx = funcidx(buffer) + 1))
	{
		P:5("%d (%d) %s", idx, toaddidx, buffer);
		Hooks_AddOne(idx, toaddidx);
	}
	end = toaddidx - 1;
	// Don't store the end, if the count goes off the end of the addresses array
	// then we need to just start reading from the AMX directly.
	P:4("Hooks_FindAll end: %s %d %d", name, toaddidx, end - (start + 1));
	return end - start;
}

/*----------------------------------------------------------------------------*\
Function:
	Hooks_RemovePublic
Params:
	from[] - Public function to remove.
	final - The return address to use instead.
Return:
	The address of "func".
Notes:
	Replaces a public function with another function that only returns the given
	value (must be -1, 0, or 1).
\*----------------------------------------------------------------------------*/

static Hooks_RemovePublic(from[], final)
{
	P:4("Hooks_RemovePublic called: \"%s\", %d", from, final);
	// The macros used add an extra "(" on to the name.  Remove it.
	new
		addr = strfind(from, "(");
	from[addr] = '\0';
	if (AMX_GetPublicEntry(0, addr, from))
	{
		new
			pointer,
			ret = AMX_Read(addr);
		switch (final)
		{
			case 0:
			{
				#emit CONST.pri   Hooks_Blank_Return0
				#emit STOR.S.pri  pointer
			}
			case -1:
			{
				#emit CONST.pri   Hooks_Blank_Return1N
				#emit STOR.S.pri  pointer
			}
			default:
			{
				#emit CONST.pri   Hooks_Blank_Return1
				#emit STOR.S.pri  pointer
			}
		}
		AMX_Write(addr, pointer);
		return ret;
	}
	return 0;
}

#define HOOKS_STRIP_ME)%0, ,

#define HOOKS_DO_ONE_CALLBACK<%0> if(!Hooks_FindAll(#%0,cidx,_:YSI_g_sCallbackStart[ALS_On%0],_:YSI_g_sCallbackEnd[ALS_On%0]))Hooks_RemovePublic(#On%0(HOOKS_STRIP_ME),ALS_R_%0);

//static Hooks_OnScriptInit()
public OnScriptInit()
{
	P:2("Hooks_OnScriptInit called");
	S@@_OnScriptInit();
	new
		cidx;
	printf(" ");
	for (new i = 0; i != 1000000; ++i) {}
	printf(" ");
	// Initialise the data for all the callbacks.
	HOOKS_DO_ONE_CALLBACK<ScriptInit>
	HOOKS_DO_ONE_CALLBACK<ScriptExit>
	HOOKS_DO_ONE_CALLBACK<GameModeInit>
	HOOKS_DO_ONE_CALLBACK<GameModeExit>
	HOOKS_DO_ONE_CALLBACK<FilterScriptInit>
	HOOKS_DO_ONE_CALLBACK<FilterScriptExit>
	HOOKS_DO_ONE_CALLBACK<PlayerConnect>
	HOOKS_DO_ONE_CALLBACK<PlayerDisconnect>
	HOOKS_DO_ONE_CALLBACK<PlayerSpawn>
	HOOKS_DO_ONE_CALLBACK<PlayerDeath>
	HOOKS_DO_ONE_CALLBACK<VehicleSpawn>
	HOOKS_DO_ONE_CALLBACK<VehicleDeath>
	HOOKS_DO_ONE_CALLBACK<PlayerText>
	HOOKS_DO_ONE_CALLBACK<PlayerCommandText>
	HOOKS_DO_ONE_CALLBACK<PlayerRequestClass>
	HOOKS_DO_ONE_CALLBACK<PlayerEnterVehicle>
	HOOKS_DO_ONE_CALLBACK<PlayerExitVehicle>
	HOOKS_DO_ONE_CALLBACK<PlayerStateChange>
	HOOKS_DO_ONE_CALLBACK<PlayerEnterCheckpoint>
	HOOKS_DO_ONE_CALLBACK<PlayerLeaveCheckpoint>
	HOOKS_DO_ONE_CALLBACK<PlayerEnterRaceCheckpoint>
	HOOKS_DO_ONE_CALLBACK<PlayerLeaveRaceCheckpoint>
	HOOKS_DO_ONE_CALLBACK<RconCommand>
	HOOKS_DO_ONE_CALLBACK<PlayerRequestSpawn>
	HOOKS_DO_ONE_CALLBACK<ObjectMoved>
	HOOKS_DO_ONE_CALLBACK<PlayerObjectMoved>
	HOOKS_DO_ONE_CALLBACK<PlayerPickUpPickup>
	HOOKS_DO_ONE_CALLBACK<VehicleMod>
	HOOKS_DO_ONE_CALLBACK<EnterExitModShop>
	HOOKS_DO_ONE_CALLBACK<VehiclePaintjob>
	HOOKS_DO_ONE_CALLBACK<VehicleRespray>
	HOOKS_DO_ONE_CALLBACK<VehicleDamageStatusUpdate>
	HOOKS_DO_ONE_CALLBACK<PlayerSelectedMenuRow>
	HOOKS_DO_ONE_CALLBACK<PlayerExitedMenu>
	HOOKS_DO_ONE_CALLBACK<PlayerInteriorChange>
	HOOKS_DO_ONE_CALLBACK<PlayerKeyStateChange>
	HOOKS_DO_ONE_CALLBACK<RconLoginAttempt>
	HOOKS_DO_ONE_CALLBACK<PlayerUpdate>
	HOOKS_DO_ONE_CALLBACK<PlayerStreamIn>
	HOOKS_DO_ONE_CALLBACK<PlayerStreamOut>
	HOOKS_DO_ONE_CALLBACK<VehicleStreamIn>
	HOOKS_DO_ONE_CALLBACK<VehicleStreamOut>
	HOOKS_DO_ONE_CALLBACK<DialogResponse>
	HOOKS_DO_ONE_CALLBACK<PlayerClickPlayer>
	HOOKS_DO_ONE_CALLBACK<PlayerGiveDamage>
	HOOKS_DO_ONE_CALLBACK<PlayerTakeDamage>
	HOOKS_DO_ONE_CALLBACK<PlayerClickMap>
	HOOKS_DO_ONE_CALLBACK<UnoccupiedVehicleUpdate>
	// 0.3e
	HOOKS_DO_ONE_CALLBACK<PlayerClickTextDraw>
	HOOKS_DO_ONE_CALLBACK<PlayerClickPlayerTextDraw>
	HOOKS_DO_ONE_CALLBACK<PlayerEditObject>
	HOOKS_DO_ONE_CALLBACK<PlayerEditAttachedObject>
	HOOKS_DO_ONE_CALLBACK<PlayerSelectObject>
	// Streamer plugin.
	#if defined _YSI_PLUGINS_STREAMER
		HOOKS_DO_ONE_CALLBACK<DynamicObjectMoved>
		HOOKS_DO_ONE_CALLBACK<PlayerEditDynamicObject>
		HOOKS_DO_ONE_CALLBACK<PlayerSelectDynamicObject>
		HOOKS_DO_ONE_CALLBACK<PlayerPickUpDynamicPickup>
		HOOKS_DO_ONE_CALLBACK<PlayerEnterDynamicCP>
		HOOKS_DO_ONE_CALLBACK<PlayerLeaveDynamicCP>
		HOOKS_DO_ONE_CALLBACK<PlayerEnterDynamicRaceCP>
		HOOKS_DO_ONE_CALLBACK<PlayerLeaveDynamicRaceCP>
		HOOKS_DO_ONE_CALLBACK<PlayerEnterDynamicArea>
		HOOKS_DO_ONE_CALLBACK<PlayerLeaveDynamicArea>
	#endif
	// YSI callbacks.
	HOOKS_DO_ONE_CALLBACK<PlayerLogin>
	HOOKS_DO_ONE_CALLBACK<PlayerLogout>
	#if defined YSI_LOCK_MODE
		YSI_gLockData[1] = floatround(floatlog(_LOCK_LEN_0 + 1), floatround_ceil);
		YSI_gLockData[0] = 5 + YSI_gLockData[1];
		YSI_gLockData[2] = YSI_gLockData[0] - 5;
		if (~strval(YSI_gLockData[5]) != ~_LOCK_IP_0)
		{
			y_lock 2;
		}
		YSI_gLockData[2] -= YSI_gLockData[1];
		YSI_gLockData[YSI_gLockData[2] + 1] -= YSI_gLockData[0];
		YSI_gLockData[1] += '.' + 5;
	#endif
	// Do all but one other callback - we already did the ALS forward first.
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnScriptInit] - 1,
		start = _:YSI_g_sCallbackStart[ALS_OnScriptInit];
	while (start++ < end)
	{
		//printf("%d %d", start, end);
		#emit PUSH.C     0
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
	}
	return ALS_R_ScriptInit;
}
#if defined _ALS_OnScriptInit
	#undef OnScriptInit
#else
	#define _ALS_OnScriptInit
#endif
#define OnScriptInit(%0) S@@_OnScriptInit(%0) <_ALS_:hooked>
ALS_FORWARD<ScriptInit>

public OnScriptExit()
{
	P:2("Hooks_OnScriptExit called");
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnScriptExit],
		start = _:YSI_g_sCallbackStart[ALS_OnScriptExit];
	do
	{
		#emit PUSH.C     0
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
	}
	while (start != end);
	return ALS_R_ScriptExit;
}
#if defined _ALS_OnScriptExit
	#undef OnScriptExit
#else
	#define _ALS_OnScriptExit
#endif
#define OnScriptExit(%0) S@@_OnScriptExit(%0)
HOOK_FORWARD<ScriptExit>

public OnGameModeInit()
{
	P:2("Hooks_OnGameModeInit called");
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnGameModeInit],
		start = _:YSI_g_sCallbackStart[ALS_OnGameModeInit];
	do
	{
		//printf("Hooks_OnGameModeInit: %d %d %d", start, end, YSI_g_sCallbackAddresses[start]);
		#emit PUSH.C     0
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
	}
	while (start != end);
	return ALS_R_GameModeExit;
}
#if defined _ALS_OnGameModeInit
	#undef OnGameModeInit
#else
	#define _ALS_OnGameModeInit
#endif
#define OnGameModeInit(%0) S@@_OnGameModeInit(%0)
HOOK_FORWARD<GameModeInit>

public OnGameModeExit()
{
	P:2("Hooks_OnGameModeExit called");
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnGameModeExit],
		start = _:YSI_g_sCallbackStart[ALS_OnGameModeExit];
	do
	{
		#emit PUSH.C     0
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
	}
	while (start != end);
	return ALS_R_GameModeExit;
}
#if defined _ALS_OnGameModeExit
	#undef OnGameModeExit
#else
	#define _ALS_OnGameModeExit
#endif
#define OnGameModeExit(%0) S@@_OnGameModeExit(%0)
HOOK_FORWARD<GameModeExit>

public OnFilterScriptInit()
{
	P:2("Hooks_OnFilterScriptInit called");
	#if defined YSI_LOCK_MODE
		if (strval(YSI_gLockData[strfind(YSI_gLockData[5], YSI_gLockData[1])]) | strval(YSI_gLockData[strfind(YSI_gLockData[YSI_gLockData[0]], YSI_gLockData[1], _, 1)]) << 8 != _LOCK_IP_1 | _LOCK_IP_2 << 8)
		{
			y_lock 4;
		}
	#endif
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnFilterScriptInit],
		start = _:YSI_g_sCallbackStart[ALS_OnFilterScriptInit];
	do
	{
		#emit PUSH.C     0
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
	}
	while (start != end);
	return ALS_R_FilterScriptInit;
}
#if defined _ALS_OnFilterScriptInit
	#undef OnFilterScriptInit
#else
	#define _ALS_OnFilterScriptInit
#endif
#define OnFilterScriptInit(%0) S@@_OnFilterScriptInit(%0)
HOOK_FORWARD<FilterScriptInit>

public OnFilterScriptExit()
{
	P:2("Hooks_OnFilterScriptExit called");
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnFilterScriptExit],
		start = _:YSI_g_sCallbackStart[ALS_OnFilterScriptExit];
	do
	{
		#emit PUSH.C     0
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
	}
	while (start != end);
	return ALS_R_FilterScriptExit;
}
#if defined _ALS_OnFilterScriptExit
	#undef OnFilterScriptExit
#else
	#define _ALS_OnFilterScriptExit
#endif
#define OnFilterScriptExit(%0) S@@_OnFilterScriptExit(%0)
HOOK_FORWARD<FilterScriptExit>

public OnPlayerConnect(playerid)
{
	P:2("Hooks_OnPlayerConnect called: %d", playerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerConnect],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerConnect],
		ret = ALS_R_PlayerConnect;
	do
	{
		#emit PUSH.S playerid
		#emit PUSH.C     4
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerConnect
	#undef OnPlayerConnect
#else
	#define _ALS_OnPlayerConnect
#endif
#define OnPlayerConnect(%0) S@@_OnPlayerConnect(%0)
HOOK_FORWARD<PlayerConnect>

public OnPlayerDisconnect(playerid, reason)
{
	P:2("Hooks_OnPlayerDisconnect called: %d, %d", playerid, reason);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerDisconnect],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerDisconnect],
		ret = ALS_R_PlayerDisconnect;
	do
	{
		#emit PUSH.S reason
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerDisconnect
	#undef OnPlayerDisconnect
#else
	#define _ALS_OnPlayerDisconnect
#endif
#define OnPlayerDisconnect(%0) S@@_OnPlayerDisconnect(%0)
HOOK_FORWARD<PlayerDisconnect>

public OnPlayerSpawn(playerid)
{
	P:2("Hooks_OnPlayerSpawn called: %d", playerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerSpawn],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerSpawn],
		ret = ALS_R_PlayerSpawn;
	do
	{
		#emit PUSH.S playerid
		#emit PUSH.C     4
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerSpawn
	#undef OnPlayerSpawn
#else
	#define _ALS_OnPlayerSpawn
#endif
#define OnPlayerSpawn(%0) S@@_OnPlayerSpawn(%0)
HOOK_FORWARD<PlayerSpawn>

public OnPlayerDeath(playerid, killerid, reason)
{
	P:2("Hooks_OnPlayerDeath called: %d, %d, %d", playerid, killerid, reason);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerDeath],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerDeath],
		ret = ALS_R_PlayerDeath;
	do
	{
		#emit PUSH.S reason
		#emit PUSH.S killerid
		#emit PUSH.S playerid
		#emit PUSH.C     12
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerDeath
	#undef OnPlayerDeath
#else
	#define _ALS_OnPlayerDeath
#endif
#define OnPlayerDeath(%0) S@@_OnPlayerDeath(%0)
HOOK_FORWARD<PlayerDeath>

public OnVehicleSpawn(vehicleid)
{
	P:2("Hooks_OnVehicleSpawn called: %d", vehicleid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnVehicleSpawn],
		start = _:YSI_g_sCallbackStart[ALS_OnVehicleSpawn],
		ret = ALS_R_VehicleSpawn;
	do
	{
		#emit PUSH.S vehicleid
		#emit PUSH.C     4
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnVehicleSpawn
	#undef OnVehicleSpawn
#else
	#define _ALS_OnVehicleSpawn
#endif
#define OnVehicleSpawn(%0) S@@_OnVehicleSpawn(%0)
HOOK_FORWARD<VehicleSpawn>

public OnVehicleDeath(vehicleid, killerid)
{
	P:2("Hooks_OnVehicleDeath called: %d, %d", vehicleid, killerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnVehicleDeath],
		start = _:YSI_g_sCallbackStart[ALS_OnVehicleDeath],
		ret = ALS_R_VehicleDeath;
	do
	{
		#emit PUSH.S killerid
		#emit PUSH.S vehicleid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnVehicleDeath
	#undef OnVehicleDeath
#else
	#define _ALS_OnVehicleDeath
#endif
#define OnVehicleDeath(%0) S@@_OnVehicleDeath(%0)
HOOK_FORWARD<VehicleDeath>

public OnPlayerText(playerid, text[])
{
	P:2("Hooks_OnPlayerText called: %d, \"%s\"", playerid, text);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerText],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerText],
		ret = ALS_R_PlayerText;
	do
	{
		#emit PUSH.S text
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerText
	#undef OnPlayerText
#else
	#define _ALS_OnPlayerText
#endif
#define OnPlayerText(%0) S@@_OnPlayerText(%0)
HOOK_FORWARD<PlayerText>

public OnPlayerCommandText(playerid, cmdtext[])
{
	P:2("Hooks_OnPlayerCommandText called: %d, \"%s\"", playerid, cmdtext);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerCommandText],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerCommandText],
		ret = ALS_R_PlayerCommandText;
	do
	{
		#emit PUSH.S cmdtext
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		// THIS CODE IS SUBTLY DIFFERENT!
		#emit LOAD.S.alt ret
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerCommandText
	#undef OnPlayerCommandText
#else
	#define _ALS_OnPlayerCommandText
#endif
#define OnPlayerCommandText(%0) S@@_OnPlayerCommandText(%0)
HOOK_FORWARD<PlayerCommandText>

public OnPlayerRequestClass(playerid, classid)
{
	P:2("Hooks_OnPlayerRequestClass called: %d, %d", playerid, classid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerRequestClass],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerRequestClass],
		ret = ALS_R_PlayerRequestClass;
	do
	{
		#emit PUSH.S classid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerRequestClass
	#undef OnPlayerRequestClass
#else
	#define _ALS_OnPlayerRequestClass
#endif
#define OnPlayerRequestClass(%0) S@@_OnPlayerRequestClass(%0)
HOOK_FORWARD<PlayerRequestClass>

public OnPlayerEnterVehicle(playerid, vehicleid, ispassenger)
{
	P:2("Hooks_OnPlayerEnterVehicle called: %d, %d, %d", playerid, vehicleid, ispassenger);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerEnterVehicle],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerEnterVehicle],
		ret = ALS_R_PlayerEnterVehicle;
	do
	{
		#emit PUSH.S ispassenger
		#emit PUSH.S vehicleid
		#emit PUSH.S playerid
		#emit PUSH.C     12
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerEnterVehicle
	#undef OnPlayerEnterVehicle
#else
	#define _ALS_OnPlayerEnterVehicle
#endif
#define OnPlayerEnterVehicle(%0) S@@_OnPlayerEnterVehicle(%0)
HOOK_FORWARD<PlayerEnterVehicle>

public OnPlayerExitVehicle(playerid, vehicleid)
{
	P:2("Hooks_OnPlayerExitVehicle called: %d, %d", playerid, vehicleid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerExitVehicle],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerExitVehicle],
		ret = ALS_R_PlayerExitVehicle;
	do
	{
		#emit PUSH.S vehicleid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerExitVehicle
	#undef OnPlayerExitVehicle
#else
	#define _ALS_OnPlayerExitVehicle
#endif
#define OnPlayerExitVehicle(%0) S@@_OnPlayerExitVehicle(%0)
HOOK_FORWARD<PlayerExitVehicle>

public OnPlayerStateChange(playerid, newstate, oldstate)
{
	P:2("Hooks_OnPlayerStateChange called: %d, %d, %d", playerid, newstate, oldstate);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerStateChange],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerStateChange],
		ret = ALS_R_PlayerStateChange;
	do
	{
		#emit PUSH.S oldstate
		#emit PUSH.S newstate
		#emit PUSH.S playerid
		#emit PUSH.C     12
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerStateChange
	#undef OnPlayerStateChange
#else
	#define _ALS_OnPlayerStateChange
#endif
#define OnPlayerStateChange(%0) S@@_OnPlayerStateChange(%0)
HOOK_FORWARD<PlayerStateChange>

public OnPlayerEnterCheckpoint(playerid)
{
	P:2("Hooks_OnPlayerEnterCheckpoint called: %d", playerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerEnterCheckpoint],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerEnterCheckpoint],
		ret = ALS_R_PlayerEnterCheckpoint;
	do
	{
		#emit PUSH.S playerid
		#emit PUSH.C     4
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerEnterCheckpoint
	#undef OnPlayerEnterCheckpoint
#else
	#define _ALS_OnPlayerEnterCheckpoint
#endif
#define OnPlayerEnterCheckpoint(%0) S@@_OnPlayerEnterCheckpoint(%0)
HOOK_FORWARD<PlayerEnterCheckpoint>

public OnPlayerLeaveCheckpoint(playerid)
{
	P:2("Hooks_OnPlayerLeaveCheckpoint called: %d", playerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerLeaveCheckpoint],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerLeaveCheckpoint],
		ret = ALS_R_PlayerLeaveCheckpoint;
	do
	{
		#emit PUSH.S playerid
		#emit PUSH.C     4
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerLeaveCheckpoint
	#undef OnPlayerLeaveCheckpoint
#else
	#define _ALS_OnPlayerLeaveCheckpoint
#endif
#define OnPlayerLeaveCheckpoint(%0) S@@_OnPlayerLeaveCheckpoint(%0)
HOOK_FORWARD<PlayerLeaveCheckpoint>

public OnPlayerEnterRaceCheckpoint(playerid)
{
	P:2("Hooks_OnPlayerEnterRaceCheckpoint called: %d", playerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerEnterRaceCheckpoint],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerEnterRaceCheckpoint],
		ret = ALS_R_PlayerEnterRaceCheckpoint;
	do
	{
		#emit PUSH.S playerid
		#emit PUSH.C     4
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerEnterRaceCP
	#undef OnPlayerEnterRaceCheckpoint
#else
	#define _ALS_OnPlayerEnterRaceCP
#endif
#define OnPlayerEnterRaceCheckpoint(%0) S@@_OnPlayerEnterRaceCheckpoint(%0)
HOOK_FORWARD<PlayerEnterRaceCheckpoint>

public OnPlayerLeaveRaceCheckpoint(playerid)
{
	P:2("Hooks_OnPlayerLeaveRaceCheckpoint called: %d", playerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerLeaveRaceCheckpoint],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerLeaveRaceCheckpoint],
		ret = ALS_R_PlayerLeaveRaceCheckpoint;
	do
	{
		#emit PUSH.S playerid
		#emit PUSH.C     4
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerLeaveRaceCP
	#undef OnPlayerLeaveRaceCheckpoint
#else
	#define _ALS_OnPlayerLeaveRaceCP
#endif
#define OnPlayerLeaveRaceCheckpoint(%0) S@@_OnPlayerLeaveRaceCheckpoint(%0)
HOOK_FORWARD<PlayerLeaveRaceCheckpoint>

public OnRconCommand(cmd[])
{
	P:2("Hooks_OnRconCommand called: \"%s\"", cmd);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnRconCommand],
		start = _:YSI_g_sCallbackStart[ALS_OnRconCommand],
		ret = ALS_R_RconCommand;
	do
	{
		#emit PUSH.S cmd
		#emit PUSH.C     4
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnRconCommand
	#undef OnRconCommand
#else
	#define _ALS_OnRconCommand
#endif
#define OnRconCommand(%0) S@@_OnRconCommand(%0)
HOOK_FORWARD<RconCommand>

public OnPlayerRequestSpawn(playerid)
{
	P:2("Hooks_OnPlayerRequestSpawn called: %d", playerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerRequestSpawn],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerRequestSpawn],
		ret = ALS_R_PlayerRequestSpawn;
	do
	{
		//printf("start: %d", start);
		#emit PUSH.S playerid
		#emit PUSH.C     4
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
		//printf("ret: %d", ret);
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerRequestSpawn
	#undef OnPlayerRequestSpawn
#else
	#define _ALS_OnPlayerRequestSpawn
#endif
#define OnPlayerRequestSpawn(%0) S@@_OnPlayerRequestSpawn(%0)
HOOK_FORWARD<PlayerRequestSpawn>

public OnObjectMoved(objectid)
{
	P:2("Hooks_OnObjectMoved called: %d", objectid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnObjectMoved],
		start = _:YSI_g_sCallbackStart[ALS_OnObjectMoved],
		ret = ALS_R_ObjectMoved;
	do
	{
		#emit PUSH.S objectid
		#emit PUSH.C     4
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnObjectMoved
	#undef OnObjectMoved
#else
	#define _ALS_OnObjectMoved
#endif
#define OnObjectMoved(%0) S@@_OnObjectMoved(%0)
HOOK_FORWARD<ObjectMoved>

public OnPlayerObjectMoved(playerid, objectid)
{
	P:2("Hooks_OnPlayerObjectMoved called: %d, %d", playerid, objectid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerObjectMoved],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerObjectMoved],
		ret = ALS_R_PlayerObjectMoved;
	do
	{
		#emit PUSH.S objectid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerObjectMoved
	#undef OnPlayerObjectMoved
#else
	#define _ALS_OnPlayerObjectMoved
#endif
#define OnPlayerObjectMoved(%0) S@@_OnPlayerObjectMoved(%0)
HOOK_FORWARD<PlayerObjectMoved>

public OnPlayerPickUpPickup(playerid, pickupid)
{
	P:2("Hooks_OnPlayerPickUpPickup called: %d, %d", playerid, pickupid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerPickUpPickup],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerPickUpPickup],
		ret = ALS_R_PlayerPickUpPickup;
	do
	{
		#emit PUSH.S pickupid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerPickUpPickup
	#undef OnPlayerPickUpPickup
#else
	#define _ALS_OnPlayerPickUpPickup
#endif
#define OnPlayerPickUpPickup(%0) S@@_OnPlayerPickUpPickup(%0)
HOOK_FORWARD<PlayerPickUpPickup>

public OnVehicleMod(playerid, vehicleid, componentid)
{
	P:2("Hooks_OnVehicleMod called: %d, %d, %d", playerid, vehicleid, componentid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnVehicleMod],
		start = _:YSI_g_sCallbackStart[ALS_OnVehicleMod],
		ret = ALS_R_VehicleMod;
	do
	{
		#emit PUSH.S componentid
		#emit PUSH.S vehicleid
		#emit PUSH.S playerid
		#emit PUSH.C     12
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnVehicleMod
	#undef OnVehicleMod
#else
	#define _ALS_OnVehicleMod
#endif
#define OnVehicleMod(%0) S@@_OnVehicleMod(%0)
HOOK_FORWARD<VehicleMod>

public OnEnterExitModShop(playerid, enterexit, interiorid)
{
	P:2("Hooks_OnEnterExitModShop called: %d, %d, %d", playerid, enterexit, interiorid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnEnterExitModShop],
		start = _:YSI_g_sCallbackStart[ALS_OnEnterExitModShop],
		ret = ALS_R_EnterExitModShop;
	do
	{
		#emit PUSH.S interiorid
		#emit PUSH.S enterexit
		#emit PUSH.S playerid
		#emit PUSH.C     12
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnEnterExitModShop
	#undef OnEnterExitModShop
#else
	#define _ALS_OnEnterExitModShop
#endif
#define OnEnterExitModShop(%0) S@@_OnEnterExitModShop(%0)
HOOK_FORWARD<EnterExitModShop>

public OnVehiclePaintjob(playerid, vehicleid, paintjobid)
{
	P:2("Hooks_OnVehiclePaintjob called: %d, %d, %d", playerid, vehicleid, paintjobid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnVehiclePaintjob],
		start = _:YSI_g_sCallbackStart[ALS_OnVehiclePaintjob],
		ret = ALS_R_VehiclePaintjob;
	do
	{
		#emit PUSH.S paintjobid
		#emit PUSH.S vehicleid
		#emit PUSH.S playerid
		#emit PUSH.C     12
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnVehiclePaintjob
	#undef OnVehiclePaintjob
#else
	#define _ALS_OnVehiclePaintjob
#endif
#define OnVehiclePaintjob(%0) S@@_OnVehiclePaintjob(%0)
HOOK_FORWARD<VehiclePaintjob>

public OnVehicleRespray(playerid, vehicleid, color1, color2)
{
	P:2("Hooks_OnVehicleRespray called: %d, %d, %d, %d", playerid, vehicleid, color1, color2);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnVehicleRespray],
		start = _:YSI_g_sCallbackStart[ALS_OnVehicleRespray],
		ret = ALS_R_VehicleRespray;
	do
	{
		#emit PUSH.S color2
		#emit PUSH.S color1
		#emit PUSH.S vehicleid
		#emit PUSH.S playerid
		#emit PUSH.C     16
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnVehicleRespray
	#undef OnVehicleRespray
#else
	#define _ALS_OnVehicleRespray
#endif
#define OnVehicleRespray(%0) S@@_OnVehicleRespray(%0)
HOOK_FORWARD<VehicleRespray>

public OnVehicleDamageStatusUpdate(vehicleid, playerid)
{
	P:2("Hooks_OnVehicleDamageStatusUpdate called: %d, %d", vehicleid, playerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnVehicleDamageStatusUpdate],
		start = _:YSI_g_sCallbackStart[ALS_OnVehicleDamageStatusUpdate],
		ret = ALS_R_VehicleDamageStatusUpdate;
	do
	{
		#emit PUSH.S playerid
		#emit PUSH.S vehicleid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnVehicleDamageStatusUpd
	#undef OnVehicleDamageStatusUpdate
#else
	#define _ALS_OnVehicleDamageStatusUpd
#endif
#define OnVehicleDamageStatusUpdate(%0) S@@_OnVehicleDamageStatusUpdate(%0)
HOOK_FORWARD<VehicleDamageStatusUpdate>

public OnUnoccupiedVehicleUpdate(vehicleid, playerid, passenger_seat)
{
	P:2("Hooks_OnUnoccupiedVehicleUpdate called: %d, %d, %d", vehicleid, playerid, passenger_seat);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnUnoccupiedVehicleUpdate],
		start = _:YSI_g_sCallbackStart[ALS_OnUnoccupiedVehicleUpdate],
		ret = ALS_R_UnoccupiedVehicleUpdate;
	do
	{
		#emit PUSH.S passenger_seat
		#emit PUSH.S playerid
		#emit PUSH.S vehicleid
		// I wonder if I could hack the stack with a negative number so that when
		// the called function returns it puts all the header data BACK on to the
		// stack instead of removing the parameters and header.
		#emit PUSH.C     12
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnUnoccupiedVehicleUpdate
	#undef OnUnoccupiedVehicleUpdate
#else
	#define _ALS_OnUnoccupiedVehicleUpdate
#endif
#define OnUnoccupiedVehicleUpdate(%0) S@@_OnUnoccupiedVehicleUpdate(%0)
HOOK_FORWARD<UnoccupiedVehicleUpdate>

public OnPlayerSelectedMenuRow(playerid, row)
{
	P:2("Hooks_OnPlayerSelectedMenuRow called: %d, %d", playerid, row);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerSelectedMenuRow],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerSelectedMenuRow],
		ret = ALS_R_PlayerSelectedMenuRow;
	do
	{
		#emit PUSH.S row
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerSelectedMenuRow
	#undef OnPlayerSelectedMenuRow
#else
	#define _ALS_OnPlayerSelectedMenuRow
#endif
#define OnPlayerSelectedMenuRow(%0) S@@_OnPlayerSelectedMenuRow(%0)
HOOK_FORWARD<PlayerSelectedMenuRow>

public OnPlayerExitedMenu(playerid)
{
	P:2("Hooks_OnPlayerExitedMenu called: %d", playerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerExitedMenu],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerExitedMenu],
		ret = ALS_R_PlayerExitedMenu;
	do
	{
		#emit PUSH.S playerid
		#emit PUSH.C     4
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerExitedMenu
	#undef OnPlayerExitedMenu
#else
	#define _ALS_OnPlayerExitedMenu
#endif
#define OnPlayerExitedMenu(%0) S@@_OnPlayerExitedMenu(%0)
HOOK_FORWARD<PlayerExitedMenu>

public OnPlayerInteriorChange(playerid, newinteriorid, oldinteriorid)
{
	P:2("Hooks_OnPlayerInteriorChange called: %d, %d, %d", playerid, newinteriorid, oldinteriorid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerInteriorChange],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerInteriorChange],
		ret = ALS_R_PlayerInteriorChange;
	do
	{
		#emit PUSH.S oldinteriorid
		#emit PUSH.S newinteriorid
		#emit PUSH.S playerid
		#emit PUSH.C     12
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerInteriorChange
	#undef OnPlayerInteriorChange
#else
	#define _ALS_OnPlayerInteriorChange
#endif
#define OnPlayerInteriorChange(%0) S@@_OnPlayerInteriorChange(%0)
HOOK_FORWARD<PlayerInteriorChange>

public OnPlayerKeyStateChange(playerid, newkeys, oldkeys)
{
	P:2("Hooks_OnPlayerKeyStateChange called: %d, %d, %d", playerid, newkeys, oldkeys);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerKeyStateChange],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerKeyStateChange],
		ret = ALS_R_PlayerKeyStateChange;
	do
	{
		#emit PUSH.S oldkeys
		#emit PUSH.S newkeys
		#emit PUSH.S playerid
		#emit PUSH.C     12
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerKeyStateChange
	#undef OnPlayerKeyStateChange
#else
	#define _ALS_OnPlayerKeyStateChange
#endif
#define OnPlayerKeyStateChange(%0) S@@_OnPlayerKeyStateChange(%0)
HOOK_FORWARD<PlayerKeyStateChange>

public OnRconLoginAttempt(ip[], password[], success)
{
	P:2("Hooks_OnRconLoginAttempt called: \"%s\", \"%s\", %d", ip, password, success);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnRconLoginAttempt],
		start = _:YSI_g_sCallbackStart[ALS_OnRconLoginAttempt],
		ret = ALS_R_RconLoginAttempt;
	do
	{
		#emit PUSH.S success
		#emit PUSH.S password
		#emit PUSH.S ip
		#emit PUSH.C     12
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnRconLoginAttempt
	#undef OnRconLoginAttempt
#else
	#define _ALS_OnRconLoginAttempt
#endif
#define OnRconLoginAttempt(%0) S@@_OnRconLoginAttempt(%0)
HOOK_FORWARD<RconLoginAttempt>

public OnPlayerUpdate(playerid)
{
	P:7("Hooks_OnPlayerUpdate called: %d", playerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerUpdate],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerUpdate],
		ret = ALS_R_PlayerUpdate;
	do
	{
		#emit PUSH.S playerid
		#emit PUSH.C     4
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerUpdate
	#undef OnPlayerUpdate
#else
	#define _ALS_OnPlayerUpdate
#endif
#define OnPlayerUpdate(%0) S@@_OnPlayerUpdate(%0)
HOOK_FORWARD<PlayerUpdate>

public OnPlayerStreamIn(playerid, forplayerid)
{
	P:2("Hooks_OnPlayerStreamIn called: %d, %d", playerid, forplayerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerStreamIn],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerStreamIn],
		ret = ALS_R_PlayerStreamIn;
	do
	{
		#emit PUSH.S forplayerid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerStreamIn
	#undef OnPlayerStreamIn
#else
	#define _ALS_OnPlayerStreamIn
#endif
#define OnPlayerStreamIn(%0) S@@_OnPlayerStreamIn(%0)
HOOK_FORWARD<PlayerStreamIn>

public OnPlayerStreamOut(playerid, forplayerid)
{
	P:2("Hooks_OnPlayerStreamOut called: %d, %d", playerid, forplayerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerStreamOut],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerStreamOut],
		ret = ALS_R_PlayerStreamOut;
	do
	{
		#emit PUSH.S forplayerid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerStreamOut
	#undef OnPlayerStreamOut
#else
	#define _ALS_OnPlayerStreamOut
#endif
#define OnPlayerStreamOut(%0) S@@_OnPlayerStreamOut(%0)
HOOK_FORWARD<PlayerStreamOut>

public OnVehicleStreamIn(vehicleid, forplayerid)
{
	P:2("Hooks_OnVehicleStreamIn called: %d, %d", vehicleid, forplayerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnVehicleStreamIn],
		start = _:YSI_g_sCallbackStart[ALS_OnVehicleStreamIn],
		ret = ALS_R_VehicleStreamIn;
	do
	{
		#emit PUSH.S forplayerid
		#emit PUSH.S vehicleid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnVehicleStreamIn
	#undef OnVehicleStreamIn
#else
	#define _ALS_OnVehicleStreamIn
#endif
#define OnVehicleStreamIn(%0) S@@_OnVehicleStreamIn(%0)
HOOK_FORWARD<VehicleStreamIn>

public OnVehicleStreamOut(vehicleid, forplayerid)
{
	P:2("Hooks_OnVehicleStreamOut called: %d, %d", vehicleid, forplayerid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnVehicleStreamOut],
		start = _:YSI_g_sCallbackStart[ALS_OnVehicleStreamOut],
		ret = ALS_R_VehicleStreamOut;
	do
	{
		#emit PUSH.S forplayerid
		#emit PUSH.S vehicleid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnVehicleStreamOut
	#undef OnVehicleStreamOut
#else
	#define _ALS_OnVehicleStreamOut
#endif
#define OnVehicleStreamOut(%0) S@@_OnVehicleStreamOut(%0)
HOOK_FORWARD<VehicleStreamOut>

public OnDialogResponse(playerid, dialogid, response, listitem, inputtext[])
{
	P:2("Hooks_OnDialogResponse called: %d, %d, %d, %d, \"%s\"", playerid, dialogid, response, listitem, inputtext);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnDialogResponse],
		start = _:YSI_g_sCallbackStart[ALS_OnDialogResponse],
		ret = ALS_R_DialogResponse;
	do
	{
		#emit PUSH.S inputtext
		#emit PUSH.S listitem
		#emit PUSH.S response
		#emit PUSH.S dialogid
		#emit PUSH.S playerid
		#emit PUSH.C     20
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnDialogResponse
	#undef OnDialogResponse
#else
	#define _ALS_OnDialogResponse
#endif
#define OnDialogResponse(%0) S@@_OnDialogResponse(%0)
HOOK_FORWARD<DialogResponse>

public OnPlayerClickPlayer(playerid, clickedplayerid, source)
{
	P:2("Hooks_OnPlayerClickPlayer called: %d, %d, %d", playerid, clickedplayerid, source);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerClickPlayer],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerClickPlayer],
		ret = ALS_R_PlayerClickPlayer;
	do
	{
		#emit PUSH.S source
		#emit PUSH.S clickedplayerid
		#emit PUSH.S playerid
		#emit PUSH.C     12
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerClickPlayer
	#undef OnPlayerClickPlayer
#else
	#define _ALS_OnPlayerClickPlayer
#endif
#define OnPlayerClickPlayer(%0) S@@_OnPlayerClickPlayer(%0)
HOOK_FORWARD<PlayerClickPlayer>

public OnPlayerTakeDamage(playerid, issuerid, Float:amount, weaponid)
{
	P:2("Hooks_OnPlayerTakeDamage called: %d, %d, %f, %d", playerid, issuerid, Float:amount, weaponid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerTakeDamage],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerTakeDamage],
		ret = ALS_R_PlayerTakeDamage;
	do
	{
		#emit PUSH.S weaponid
		#emit PUSH.S amount
		#emit PUSH.S issuerid
		#emit PUSH.S playerid
		#emit PUSH.C     16
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerTakeDamage
	#undef OnPlayerTakeDamage
#else
	#define _ALS_OnPlayerTakeDamage
#endif
#define OnPlayerTakeDamage(%0) S@@_OnPlayerTakeDamage(%0)
HOOK_FORWARD<PlayerTakeDamage>

public OnPlayerGiveDamage(playerid, damagedid, Float:amount, weaponid)
{
	P:2("Hooks_OnPlayerGiveDamage called: %d, %d, %f, %d", playerid, damagedid, Float:amount, weaponid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerGiveDamage],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerGiveDamage],
		ret = ALS_R_PlayerGiveDamage;
	do
	{
		#emit PUSH.S weaponid
		#emit PUSH.S amount
		#emit PUSH.S damagedid
		#emit PUSH.S playerid
		#emit PUSH.C     16
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerGiveDamage
	#undef OnPlayerGiveDamage
#else
	#define _ALS_OnPlayerGiveDamage
#endif
#define OnPlayerGiveDamage(%0) S@@_OnPlayerGiveDamage(%0)
HOOK_FORWARD<PlayerGiveDamage>

#if !defined _ALS_OnPlayerLogin
	forward OnPlayerLogin(playerid, uid);
#endif

public OnPlayerLogin(playerid, uid)
{
	P:2("Hooks_OnPlayerLogin called: %d, %d", playerid, uid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerLogin],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerLogin],
		ret = ALS_R_PlayerLogin;
	do
	{
		#emit PUSH.S uid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerLogin
	#undef OnPlayerLogin
#else
	#define _ALS_OnPlayerLogin
#endif
#define OnPlayerLogin(%0) S@@_OnPlayerLogin(%0)
HOOK_FORWARD<PlayerLogin>

#if !defined _ALS_OnPlayerLogout
	forward OnPlayerLogout(playerid, uid);
#endif

public OnPlayerLogout(playerid, uid)
{
	P:2("Hooks_OnPlayerLogout called: %d, %d", playerid, uid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerLogout],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerLogout],
		ret = ALS_R_PlayerLogout;
	do
	{
		#emit PUSH.S uid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerLogout
	#undef OnPlayerLogout
#else
	#define _ALS_OnPlayerLogout
#endif
#define OnPlayerLogout(%0) S@@_OnPlayerlogout(%0)
HOOK_FORWARD<PlayerLogout>

#if !defined OnPlayerClickMap
	#undef ALS_MAKE
	#endinput
#endif

public OnPlayerClickMap(playerid, Float:fX, Float:fY, Float:fZ)
{
	P:2("Hooks_OnPlayerClickMap called: %d, %f, %f, %f", playerid, fX, fY, fZ);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerClickMap],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerClickMap],
		ret = ALS_R_PlayerClickMap;
	do
	{
		#emit PUSH.S fZ
		#emit PUSH.S fY
		#emit PUSH.S fX
		#emit PUSH.S playerid
		#emit PUSH.C     16
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerClickMap
	#undef OnPlayerClickMap
#else
	#define _ALS_OnPlayerClickMap
#endif
#define OnPlayerClickMap(%0) S@@_OnPlayerClickMap(%0)
HOOK_FORWARD<PlayerClickMap>

public OnPlayerClickTextDraw(playerid, Text:clickedid)
{
	P:2("Hooks_OnPlayerClickTextDraw called: %d, %d", playerid, _:clickedid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerClickTextDraw],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerClickTextDraw],
		ret = ALS_R_PlayerClickTextDraw;
	do
	{
		#emit PUSH.S clickedid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerClickTextDraw
	#undef OnPlayerClickTextDraw
#else
	#define _ALS_OnPlayerClickTextDraw
#endif
#define OnPlayerClickTextDraw(%0) S@@_OnPlayerClickTextDraw(%0)
HOOK_FORWARD<PlayerClickTextDraw>

public OnPlayerClickPlayerTextDraw(playerid, PlayerText:playertextid)
{
	P:2("Hooks_OnPlayerClickPlayerTextDraw called: %d, %d", playerid, _:playertextid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerClickPlayerTextDraw],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerClickPlayerTextDraw],
		ret = ALS_R_PlayerClickPlayerTextDraw;
	do
	{
		#emit PUSH.S playertextid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerClickPlayerTD
	#undef OnPlayerClickPlayerTextDraw
#else
	#define _ALS_OnPlayerClickPlayerTD
#endif
#define OnPlayerClickPlayerTextDraw(%0) S@@_OnPlayerClickPlayerTextDraw(%0)
HOOK_FORWARD<PlayerClickPlayerTextDraw>

public OnPlayerEditObject(playerid, playerobject, objectid, response, Float:fX, Float:fY, Float:fZ, Float:fRotX, Float:fRotY, Float:fRotZ)
{
	P:2("Hooks_OnPlayerEditObject called: %d, %d, %d, %d, %f, %f, %f, %f, %f, %f", playerid, playerobject, objectid, response, fX, fY, fZ, fRotX, fRotY, fRotZ);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerEditObject],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerEditObject],
		ret = ALS_R_PlayerEditObject;
	do
	{
		#emit PUSH.S fRotZ
		#emit PUSH.S fRotY
		#emit PUSH.S fRotX
		#emit PUSH.S fZ
		#emit PUSH.S fY
		#emit PUSH.S fX
		#emit PUSH.S response
		#emit PUSH.S objectid
		#emit PUSH.S playerobject
		#emit PUSH.S playerid
		#emit PUSH.C     40
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerEditObject
	#undef OnPlayerEditObject
#else
	#define _ALS_OnPlayerEditObject
#endif
#define OnPlayerEditObject(%0) S@@_OnPlayerEditObject(%0)
HOOK_FORWARD<PlayerEditObject>
//forward S@@_OnPlayerEditObject(playerid,playerobject,objectid,response,Float:fX,Float:fY,Float:fZ,Float:fRotX,Float:fRotY,Float:fRotZ);
//public S@@_OnPlayerEditObject(playerid,playerobject,objectid,response,Float:fX,Float:fY,Float:fZ,Float:fRotX,Float:fRotY,Float:fRotZ)<_ALS_:unhooked>{return 1;}
//public S@@_OnPlayerEditObject(playerid,playerobject,objectid,response,Float:fX,Float:fY,Float:fZ,Float:fRotX,Float:fRotY,Float:fRotZ)<>{return 1;}

public OnPlayerEditAttachedObject(playerid, response, index, modelid, boneid, Float:fOffsetX, Float:fOffsetY, Float:fOffsetZ, Float:fRotX, Float:fRotY, Float:fRotZ, Float:fScaleX, Float:fScaleY, Float:fScaleZ)
{
	P:2("Hooks_OnPlayerEditAttachedObject called: %d, %d, %d, %d, %d, %f, %f, %f, %f, %f, %f, %f, %f, %f", playerid, response, index, modelid, boneid, fOffsetX, fOffsetY, fOffsetZ, fRotX, fRotY, fRotZ, fScaleX, fScaleY, fScaleZ);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerEditAttachedObject],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerEditAttachedObject],
		ret = ALS_R_PlayerEditAttachedObject;
	do
	{
		#emit PUSH.S fScaleZ
		#emit PUSH.S fScaleY
		#emit PUSH.S fScaleX
		#emit PUSH.S fRotZ
		#emit PUSH.S fRotY
		#emit PUSH.S fRotX
		#emit PUSH.S fOffsetZ
		#emit PUSH.S fOffsetY
		#emit PUSH.S fOffsetX
		#emit PUSH.S boneid
		#emit PUSH.S modelid
		#emit PUSH.S index
		#emit PUSH.S response
		#emit PUSH.S playerid
		#emit PUSH.C     56
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerEditAttachedObject
	#undef OnPlayerEditAttachedObject
#else
	#define _ALS_OnPlayerEditAttachedObject
#endif
#define OnPlayerEditAttachedObject(%0) S@@_OnPlayerEditAttachedObject(%0)
HOOK_FORWARD<PlayerEditAttachedObject>
//forward S@@_OnPlayerEditAttachedObject(playerid,response,index,modelid,boneid,Float:fOffsetX,Float:fOffsetY,Float:fOffsetZ,Float:fRotX,Float:fRotY,Float:fRotZ,Float:fScaleX,Float:fScaleY,Float:fScaleZ);
//public S@@_OnPlayerEditAttachedObject(playerid,response,index,modelid,boneid,Float:fOffsetX,Float:fOffsetY,Float:fOffsetZ,Float:fRotX,Float:fRotY,Float:fRotZ,Float:fScaleX,Float:fScaleY,Float:fScaleZ)<_ALS_:unhooked>{return 1;}
//public S@@_OnPlayerEditAttachedObject(playerid,response,index,modelid,boneid,Float:fOffsetX,Float:fOffsetY,Float:fOffsetZ,Float:fRotX,Float:fRotY,Float:fRotZ,Float:fScaleX,Float:fScaleY,Float:fScaleZ)<>{return 1;}

public OnPlayerSelectObject(playerid, type, objectid, modelid, Float:fX, Float:fY, Float:fZ)
{
	P:2("Hooks_OnPlayerSelectObject called: %d, %d, %d, %d, %f, %f, %f", playerid, type, objectid, modelid, fX, fY, fZ);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerSelectObject],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerSelectObject],
		ret = ALS_R_PlayerSelectObject;
	do
	{
		#emit PUSH.S fZ
		#emit PUSH.S fY
		#emit PUSH.S fX
		#emit PUSH.S modelid
		#emit PUSH.S objectid
		#emit PUSH.S type
		#emit PUSH.S playerid
		#emit PUSH.C     28
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerSelectObject
	#undef OnPlayerSelectObject
#else
	#define _ALS_OnPlayerSelectObject
#endif
#define OnPlayerSelectObject(%0) S@@_OnPlayerSelectObject(%0)
HOOK_FORWARD<PlayerSelectObject>

// Allow hooking of streamer plugin callbacks.
#if !defined _YSI_PLUGINS_STREAMER
	#undef ALS_MAKE
	#endinput
#endif

public OnDynamicObjectMoved(objectid)
{
	P:2("Hooks_OnDynamicObjectMoved called: %d", objectid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnDynamicObjectMoved],
		start = _:YSI_g_sCallbackStart[ALS_OnDynamicObjectMoved],
		ret = ALS_R_DynamicObjectMoved;
	do
	{
		#emit PUSH.S objectid
		#emit PUSH.C     4
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnDynamicObjectMoved
	#undef OnDynamicObjectMoved
#else
	#define _ALS_OnDynamicObjectMoved
#endif
#define OnDynamicObjectMoved(%0) S@@_OnDynamicObjectMoved(%0)
HOOK_FORWARD<DynamicObjectMoved>

public OnPlayerEditDynamicObject(playerid, objectid, response, Float:x, Float:y, Float:z, Float:rx, Float:ry, Float:rz)
{
	P:2("Hooks_OnPlayerEditDynamicObject called: %d, %d, %d, %f, %f, %f, %f, %f, %f", playerid, objectid, response, x, y, z, rx, ry, rz);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerEditDynamicObject],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerEditDynamicObject],
		ret = ALS_R_PlayerEditDynamicObject;
	do
	{
		#emit PUSH.S rz
		#emit PUSH.S ry
		#emit PUSH.S rx
		#emit PUSH.S z
		#emit PUSH.S y
		#emit PUSH.S x
		#emit PUSH.S response
		#emit PUSH.S objectid
		#emit PUSH.S playerid
		#emit PUSH.C     36
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerEditDynamicObject
	#undef OnPlayerEditDynamicObject
#else
	#define _ALS_OnPlayerEditDynamicObject
#endif
#define OnPlayerEditDynamicObject(%0) S@@_OnPlayerEditDynamicObject(%0)
HOOK_FORWARD<PlayerEditDynamicObject>
//forward S@@_OnPlayerEditDynamicObject(playerid, objectid, response, Float:x, Float:y, Float:z, Float:rx, Float:ry, Float:rz);
//public S@@_OnPlayerEditDynamicObject(playerid, objectid, response, Float:x, Float:y, Float:z, Float:rx, Float:ry, Float:rz)<_ALS_:unhooked>{return 1;}
//public S@@_OnPlayerEditDynamicObject(playerid, objectid, response, Float:x, Float:y, Float:z, Float:rx, Float:ry, Float:rz)<>{return 1;}

public OnPlayerSelectDynamicObject(playerid, objectid, modelid, Float:x, Float:y, Float:z)
{
	P:2("Hooks_OnPlayerSelectDynamicObject called: %d, %d, %d, %f, %f, %f", playerid, objectid, modelid, x, y, z);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerSelectDynamicObject],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerSelectDynamicObject],
		ret = ALS_R_PlayerSelectDynamicObject;
	do
	{
		#emit PUSH.S z
		#emit PUSH.S y
		#emit PUSH.S x
		#emit PUSH.S modelid
		#emit PUSH.S objectid
		#emit PUSH.S playerid
		#emit PUSH.C     24
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerSelectDynamicObj
	#undef OnPlayerSelectDynamicObject
#else
	#define _ALS_OnPlayerSelectDynamicObj
#endif
#define OnPlayerSelectDynamicObject(%0) S@@_OnPlayerSelectDynamicObject(%0)
HOOK_FORWARD<PlayerSelectDynamicObject>
//forward S@@_OnPlayerEditDynamicObject(playerid, objectid, modelid, Float:x, Float:y, Float:z);
//public S@@_OnPlayerEditDynamicObject(playerid, objectid, modelid, Float:x, Float:y, Float:z)<_ALS_:unhooked>{return 1;}
//public S@@_OnPlayerEditDynamicObject(playerid, objectid, modelid, Float:x, Float:y, Float:z)<>{return 1;}

public OnPlayerPickUpDynamicPickup(playerid, pickupid)
{
	P:2("Hooks_OnPlayerPickUpDynamicPickup called: %d, %d", playerid, pickupid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerPickUpDynamicPickup],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerPickUpDynamicPickup],
		ret = ALS_R_PlayerPickUpDynamicPickup;
	do
	{
		#emit PUSH.S pickupid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerPickUpDynamicPUp
	#undef OnPlayerPickUpDynamicPickup
#else
	#define _ALS_OnPlayerPickUpDynamicPUp
#endif
#define OnPlayerPickUpDynamicPickup(%0) S@@_OnPlayerPickUpDynamicPickup(%0)
HOOK_FORWARD<PlayerPickUpDynamicPickup>

public OnPlayerEnterDynamicCP(playerid, checkpointid)
{
	P:2("Hooks_OnPlayerEnterDynamicCP called: %d, %d", playerid, checkpointid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerEnterDynamicCP],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerEnterDynamicCP],
		ret = ALS_R_PlayerEnterDynamicCP;
	do
	{
		#emit PUSH.S checkpointid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerEnterDynamicCP
	#undef OnPlayerEnterDynamicCP
#else
	#define _ALS_OnPlayerEnterDynamicCP
#endif
#define OnPlayerEnterDynamicCP(%0) S@@_OnPlayerEnterDynamicCP(%0)
HOOK_FORWARD<PlayerEnterDynamicCP>

public OnPlayerLeaveDynamicCP(playerid, checkpointid)
{
	P:2("Hooks_OnPlayerLeaveDynamicCP called: %d, %d", playerid, checkpointid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerLeaveDynamicCP],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerLeaveDynamicCP],
		ret = ALS_R_PlayerLeaveDynamicCP;
	do
	{
		#emit PUSH.S checkpointid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerLeaveDynamicCP
	#undef OnPlayerLeaveDynamicCP
#else
	#define _ALS_OnPlayerLeaveDynamicCP
#endif
#define OnPlayerLeaveDynamicCP(%0) S@@_OnPlayerLeaveDynamicCP(%0)
HOOK_FORWARD<PlayerLeaveDynamicCP>

public OnPlayerEnterDynamicRaceCP(playerid, checkpointid)
{
	P:2("Hooks_OnPlayerEnterDynamicRaceCP called: %d, %d", playerid, checkpointid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerEnterDynamicRaceCP],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerEnterDynamicRaceCP],
		ret = ALS_R_PlayerEnterDynamicRaceCP;
	do
	{
		#emit PUSH.S checkpointid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerEnterDynamicRaceCP
	#undef OnPlayerEnterDynamicRaceCP
#else
	#define _ALS_OnPlayerEnterDynamicRaceCP
#endif
#define OnPlayerEnterDynamicRaceCP(%0) S@@_OnPlayerEnterDynamicRaceCP(%0)
HOOK_FORWARD<PlayerEnterDynamicRaceCP>

public OnPlayerLeaveDynamicRaceCP(playerid, checkpointid)
{
	P:2("Hooks_OnPlayerLeaveDynamicRaceCP called: %d, %d", playerid, checkpointid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerLeaveDynamicRaceCP],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerLeaveDynamicRaceCP],
		ret = ALS_R_PlayerLeaveDynamicRaceCP;
	do
	{
		#emit PUSH.S checkpointid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerLeaveDynamicRaceCP
	#undef OnPlayerLeaveDynamicRaceCP
#else
	#define _ALS_OnPlayerLeaveDynamicRaceCP
#endif
#define OnPlayerLeaveDynamicRaceCP(%0) S@@_OnPlayerLeaveDynamicRaceCP(%0)
HOOK_FORWARD<PlayerLeaveDynamicRaceCP>

public OnPlayerEnterDynamicArea(playerid, areaid)
{
	P:2("Hooks_OnPlayerEnterDynamicArea called: %d, %d", playerid, areaid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerEnterDynamicArea],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerEnterDynamicArea],
		ret = ALS_R_PlayerEnterDynamicArea;
	do
	{
		#emit PUSH.S areaid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerEnterDynamicArea
	#undef OnPlayerEnterDynamicArea
#else
	#define _ALS_OnPlayerEnterDynamicArea
#endif
#define OnPlayerEnterDynamicArea(%0) S@@_OnPlayerEnterDynamicArea(%0)
HOOK_FORWARD<PlayerEnterDynamicArea>

public OnPlayerLeaveDynamicArea(playerid, areaid)
{
	P:2("Hooks_OnPlayerLeaveDynamicArea called: %d, %d", playerid, areaid);
	new
		end   = _:YSI_g_sCallbackEnd[ALS_OnPlayerLeaveDynamicArea],
		start = _:YSI_g_sCallbackStart[ALS_OnPlayerLeaveDynamicArea],
		ret = ALS_R_PlayerLeaveDynamicArea;
	do
	{
		#emit PUSH.S areaid
		#emit PUSH.S playerid
		#emit PUSH.C     8
		#emit CONST.alt  YSI_g_sCallbackAddresses
		#emit LOAD.S.pri start
		#emit INC.pri
		#emit STOR.S.pri start
		#emit LIDX
		#emit MOVE.alt
		#emit LCTRL      6
		#emit ADD.C      24
		#emit PUSH.pri
		#emit MOVE.pri
		#emit SCTRL      6
		#emit MOVE.alt
		#emit CONST.pri  0xFFFFFFFE
		#emit AND
		#emit PUSH.pri
		#emit LOAD.S.pri ret
		#emit AND
		#emit POP.alt
		#emit OR
		#emit STOR.S.pri ret
	}
	while (start != end && ret >= 0);
	return (ret == 1);
}
#if defined _ALS_OnPlayerLeaveDynamicArea
	#undef OnPlayerLeaveDynamicArea
#else
	#define _ALS_OnPlayerLeaveDynamicArea
#endif
#define OnPlayerLeaveDynamicArea(%0) S@@_OnPlayerLeaveDynamicArea(%0)
HOOK_FORWARD<PlayerLeaveDynamicArea>

#undef ALS_MAKE
